#include <cstdio>
#include <algorithm>
#include <vector>

using namespace std;

class UnionFind {
public:
  // Nodes are numbered from 1 to N.
  UnionFind(int N) : parent(N+1), rank(N+1) {}

  int find(int x) {
    if (parent[x] == 0) return x;
    parent[x] = find(parent[x]);
    return parent[x];
  }

  void do_union(int x, int y) {
    int xRoot = find(x), yRoot = find(y);
    if (xRoot == yRoot) return;
    if (rank[xRoot] < rank[yRoot])
      parent[xRoot] = yRoot;
    else if (rank[xRoot] > rank[yRoot])
      parent[yRoot] = xRoot;
    else {
      parent[yRoot] = xRoot;
      rank[xRoot]++;
    }
  }

private:
  vector<int> parent, rank;
};

int main() {
#ifdef CONTEST
  freopen("villages.in", "rt", stdin);
  freopen("villages.out", "wt", stdout);
#endif
  int N, M, K;
  scanf("%d %d %d", &N, &M, &K);
  UnionFind UF(N);
  for (int i = 0; i < M; ++i) {
    int u, v;
    scanf("%d %d", &u, &v);
    UF.do_union(u, v);
  }
  vector<bool> leader(N+1);
  int groups = 0;
  for (int u = 1; u <= N; ++u) {
    int p = UF.find(u);
    if (!leader[p]) { leader[p] = true; ++groups; }
  }
  printf("%d\n", groups > K ? groups - K : 1);
}
